function [out] = fix_image_width(in, desidered_width, filling)
% in = an image
% desidered_width = the width of the output image
% filling = the value used for filling the external boundaries (>1 = 1, <=0
% = 0
    s = size(in);
    if s(2) >= desidered_width
        out = in;
    else
        if filling > 0
            out = ones(s(1), desidered_width);
        else
            out = zeros(s(1), desidered_width);
        end
        ini =ceil((desidered_width - s(2))/2.0);
        out(:,ini:size(in,2)+ini-1) = in;
    end
end